<?php
// Inicia a sessão para acessar os dados do usuário.
session_start();

// Verifica se o usuário está logado e se o perfil é de professor.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'PROFESSOR') {
    header("Location: login.php");
    exit;
}

// Inclui o arquivo de conexão com o banco de dados.
include 'conexao.php';
// Inclui o arquivo que verifica o login, se necessário.
include 'verifica_login.php';

// Obtém os dados do usuário da sessão.
$usuario = $_SESSION['usuario'];
$nome_usuario = $usuario['nome'] ?? 'Professor';
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gráfico de Notas - SISMAG</title>
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">

<div class="max-w-4xl mx-auto bg-white p-6 rounded-xl shadow-md text-center">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Gráfico de Notas</h1>
    <p class="text-gray-600 mb-4">Olá, professor(a) <?= htmlspecialchars($nome_usuario) ?>. Esta página é destinada a exibir gráficos de desempenho dos alunos.</p>

    <!-- Placeholder para o gráfico. Você pode usar uma biblioteca como Chart.js aqui no futuro. -->
    <div class="bg-gray-200 h-96 flex items-center justify-center rounded-lg shadow-inner mt-8">
        <span class="text-gray-500 text-lg">O gráfico será exibido aqui.</span>
    </div>
</div>

</body>
</html>